/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.block.entity.ModBlockEntityTypes;
import dev.ftb.extendedexchange.inventory.BaseItemStackHandler;
import dev.ftb.extendedexchange.menu.AlchemyTableMenu;
import dev.ftb.extendedexchange.recipes.AlchemyTableRecipe;
import dev.ftb.extendedexchange.recipes.RecipeCache;
import java.util.Optional;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableBlockEntity
extends AbstractEMCBlockEntity
implements MenuProvider {
    public int progress = 0;
    public long totalCost = 0L;
    public int craftingTime = 0;
    public final TrackedData trackedData = new TrackedData();
    public int progressDisplay;
    public int costDisplay;
    private final ItemStackHandler inventory = new BaseItemStackHandler<AlchemyTableBlockEntity>(this, 2){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot == 0 && AlchemyTableBlockEntity.this.findRecipeFor(stack).isPresent();
        }
    };
    private final IItemHandler wrapped = new WrappedAlchemyHandler(this.inventory);
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(() -> this.wrapped);

    public AlchemyTableBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.ALCHEMY_TABLE.get(), blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void tickServer() {
        boolean hasOutput;
        super.tickServer();
        this.totalCost = 0L;
        this.craftingTime = 0;
        ItemStack output = this.inventory.getStackInSlot(1);
        boolean bl = hasOutput = !output.m_41619_();
        if (this.inventory.getStackInSlot(0).m_41619_() || hasOutput && output.m_41613_() >= output.m_41741_()) {
            return;
        }
        ItemStack input = this.inventory.getStackInSlot(0);
        this.findRecipeFor(input).ifPresent(recipe -> {
            ItemStack result = recipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{input}));
            if (!hasOutput || ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)result)) {
                this.totalCost = recipe.getTotalCost(input);
                this.craftingTime = recipe.getCraftingTime();
                if (this.storedEMC >= this.totalCost) {
                    if (++this.progress >= this.craftingTime) {
                        this.storedEMC -= this.totalCost;
                        this.progress = 0;
                        this.inventory.extractItem(0, 1, false);
                        ItemStack newOutput = hasOutput ? ItemHandlerHelper.copyStackWithSize((ItemStack)output, (int)(output.m_41613_() + 1)) : result;
                        this.inventory.setStackInSlot(1, newOutput);
                    }
                    this.m_6596_();
                }
            }
        });
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public long insertEmc(long emc, IEmcStorage.EmcAction action) {
        if (!this.nonNullLevel().m_5776_()) {
            if (this.totalCost <= 0L) {
                return 0L;
            }
            long toInsert = Math.min(emc, this.getMaximumEmc() - this.storedEMC);
            this.storedEMC += toInsert;
            this.m_6596_();
            return toInsert;
        }
        return 0L;
    }

    @Override
    public long getMaximumEmc() {
        return this.totalCost * 8L;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    private Optional<AlchemyTableRecipe> findRecipeFor(ItemStack input) {
        return RecipeCache.ALCHEMY.getCachedRecipe(this.nonNullLevel(), (Container)new SimpleContainer(new ItemStack[]{input}));
    }

    @Override
    public NonNullList<ItemStack> getContentsToDrop() {
        NonNullList res = NonNullList.m_122779_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            res.add((Object)this.inventory.getStackInSlot(i));
        }
        return res;
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.extendedexchange.alchemy_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new AlchemyTableMenu(windowId, inv, this.m_58899_());
    }

    public class TrackedData
    implements ContainerData {
        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> Math.min(255, AlchemyTableBlockEntity.this.craftingTime <= 0 ? 0 : AlchemyTableBlockEntity.this.progress * 255 / AlchemyTableBlockEntity.this.craftingTime);
                case 1 -> Math.min(255, (double)AlchemyTableBlockEntity.this.totalCost <= 0.0 ? 0 : (int)(AlchemyTableBlockEntity.this.storedEMC * 255L / AlchemyTableBlockEntity.this.totalCost));
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AlchemyTableBlockEntity.this.progressDisplay = value;
                    break;
                }
                case 1: {
                    AlchemyTableBlockEntity.this.costDisplay = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    }

    private static class WrappedAlchemyHandler
    implements IItemHandler {
        private final ItemStackHandler wrapped;

        public WrappedAlchemyHandler(ItemStackHandler inventory) {
            this.wrapped = inventory;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return slot == 0 ? this.wrapped.insertItem(slot, stack, simulate) : stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            return slot == 1 ? this.wrapped.extractItem(slot, count, simulate) : ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

